<?php

namespace Artemis\Loyalty\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class LoyaltySettingUpdated
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $key;
    public $oldValue;
    public $newValue;

    public function __construct(string $key, $oldValue, $newValue)
    {
        $this->key = $key;
        $this->oldValue = $oldValue;
        $this->newValue = $newValue;
    }
}
