<?php

namespace Artemis\Loyalty\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class PointsEarned
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $user;
    public $amount;
    public $source;
    public $meta;

    public function __construct($user, int $amount, string $source = 'manual', array $meta = [])
    {
        $this->user = $user;
        $this->amount = $amount;
        $this->source = $source;
        $this->meta = $meta;
    }
}
