<?php

namespace Artemis\Loyalty\Listeners;

use Artemis\Loyalty\Enums\PointTransactionTypeEnum;
use Artemis\Loyalty\Models\PointTransaction;

class AddReferralBonusListener
{
    public function handle(\Artemis\Loyalty\Events\ReferralMade $event)
    {
        $event->referrer->increment('total_points', $event->bonus);

        PointTransaction::create([
            'user_id' => $event->referrer->id,
            'points' => $event->bonus,
            'description' => 'معرفی کاربر جدید',
            'type' => PointTransactionTypeEnum::DEPOSIT->value,
        ]);
    }
}
