<?php

namespace Artemis\Loyalty\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Artemis\Loyalty\Events\PointsEarned;
use Artemis\Loyalty\Events\PointsRedeemed;
use Artemis\Loyalty\Events\TierUpgraded;
use Artemis\Loyalty\Events\ReferralMade;
use Artemis\Loyalty\Events\RewardCreated;
use Artemis\Loyalty\Events\LoyaltySettingUpdated;
use Artemis\Loyalty\Listeners\LogPointsTransactionListener;
use Artemis\Loyalty\Listeners\SendRedemptionNotification;
use Artemis\Loyalty\Listeners\AddReferralBonusListener;
use Artemis\Loyalty\Listeners\ApplyTierUpgradeListener;
use Artemis\Loyalty\Listeners\AuditLoyaltySettingListener;

class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        PointsEarned::class => [
            LogPointsTransactionListener::class,
            ApplyTierUpgradeListener::class,
        ],
        PointsRedeemed::class => [
            SendRedemptionNotification::class,
        ],
        ReferralMade::class => [
            AddReferralBonusListener::class,
        ],
        LoyaltySettingUpdated::class => [
            AuditLoyaltySettingListener::class,
        ],
        // You can optionally hook RewardCreated and TierUpgraded if needed later
    ];
}
